/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.blockui;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.blockui.BlockUI;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class BlockUIRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BlockUI blockUI = (BlockUI)component;
        this.encodeMarkup(context, component);
        this.encodeScript(context, blockUI);
    }

    protected void encodeScript(FacesContext context, BlockUI blockUI) throws IOException {
        String clientId = blockUI.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("BlockUI", blockUI.resolveWidgetVar(), clientId);
        wb.attr("block", SearchExpressionFacade.resolveClientIds(context, (UIComponent)blockUI, blockUI.getBlock()));
        wb.attr("triggers", SearchExpressionFacade.resolveClientIds(context, (UIComponent)blockUI, blockUI.getTrigger()), null);
        wb.attr("blocked", blockUI.isBlocked(), false);
        wb.attr("animate", blockUI.isAnimate(), true);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BlockUI blockUI = (BlockUI)component;
        String clientId = blockUI.getClientId(context);
        writer.startElement("div", (UIComponent)blockUI);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"ui-blockui-content ui-widget ui-widget-content ui-corner-all ui-helper-hidden ui-shadow", null);
        this.renderChildren(context, (UIComponent)blockUI);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

