/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class ScrollFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        throw new RuntimeException("RowScrollFeature should not decode.");
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_scrollOffset"));
        int scrollRows = table.getScrollRows();
        String clientId = table.getClientId(context);
        table.setScrollOffset(scrollOffset);
        if (table.isLazy()) {
            table.loadLazyScrollData(scrollOffset, scrollRows);
        }
        if (table.isSelectionEnabled()) {
            table.findSelectedRowKeys();
        }
        for (int i = scrollOffset; i < scrollOffset + table.getScrollRows(); ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) continue;
            renderer.encodeRow(context, table, clientId, i);
        }
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_scrolling");
    }
}

