/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputmask;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputmask.InputMask;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class InputMaskRenderer
extends InputRenderer {
    private static final Logger logger = Logger.getLogger(InputMaskRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        InputMask inputMask = (InputMask)component;
        if (inputMask.isDisabled() || inputMask.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputMask);
        String clientId = inputMask.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            inputMask.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputMask inputMask = (InputMask)component;
        this.encodeMarkup(context, inputMask);
        this.encodeScript(context, inputMask);
    }

    protected void encodeScript(FacesContext context, InputMask inputMask) throws IOException {
        String clientId = inputMask.getClientId(context);
        String mask = inputMask.getMask();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputMask", inputMask.resolveWidgetVar(), clientId);
        String placeHolder = inputMask.getPlaceHolder();
        String slotChar = inputMask.getSlotChar();
        if (placeHolder != null) {
            logger.warning("placeHolder attribute is deprecated, use slotChar instead.");
        }
        if (slotChar == null) {
            slotChar = placeHolder;
        }
        if (mask != null) {
            wb.attr("mask", mask).attr("placeholder", slotChar, null);
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, InputMask inputMask) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputMask.getClientId(context);
        String styleClass = inputMask.getStyleClass();
        String defaultClass = "ui-inputfield ui-inputmask ui-widget ui-state-default ui-corner-all";
        defaultClass = !inputMask.isValid() ? defaultClass + " ui-state-error" : defaultClass;
        defaultClass = inputMask.isDisabled() ? defaultClass + " ui-state-disabled" : defaultClass;
        styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputMask);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)inputMask, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputMask, HTML.INPUT_TEXT_EVENTS);
        if (inputMask.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (inputMask.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (inputMask.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputMask.getStyle(), "style");
        }
        if (inputMask.isRequired()) {
            writer.writeAttribute("aria-required", (Object)"true", null);
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)inputMask);
        }
        writer.endElement("input");
    }
}

