/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputlabel;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.config.ConfigContainer;
import org.primefaces.context.RequestContext;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.metadata.transformer.AbstractInputMetadataTransformer;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class OutputLabelRenderer
extends CoreRenderer {
    private static final Logger LOG = Logger.getLogger(OutputLabelRenderer.class.getName());

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OutputLabel label = (OutputLabel)component;
        String clientId = label.getClientId(context);
        String value = ComponentUtils.getValueToRender(context, (UIComponent)label);
        UIComponent target = null;
        String targetClientId = null;
        UIInput input = null;
        String styleClass = label.getStyleClass();
        styleClass = styleClass == null ? "ui-outputlabel ui-widget" : "ui-outputlabel ui-widget " + styleClass;
        String _for = label.getFor();
        if (_for != null) {
            target = SearchExpressionFacade.resolveComponent(context, (UIComponent)label, _for);
            String string = targetClientId = target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(context);
            if (target instanceof UIInput) {
                input = (UIInput)target;
                if (value != null && (input.getAttributes().get("label") == null || input.getValueExpression("label") == null)) {
                    ValueExpression ve = label.getValueExpression("value");
                    if (ve != null) {
                        input.setValueExpression("label", ve);
                    } else {
                        String labelString = value;
                        int colonPos = labelString.lastIndexOf(":");
                        if (colonPos != -1) {
                            labelString = labelString.substring(0, colonPos);
                        }
                        input.getAttributes().put("label", labelString);
                    }
                }
                if (!input.isValid()) {
                    styleClass = styleClass + " ui-state-error";
                }
            }
        }
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        this.renderPassThruAttributes(context, (UIComponent)label, HTML.LABEL_ATTRS);
        if (target != null) {
            writer.writeAttribute("for", (Object)targetClientId, "for");
        }
        if (value != null) {
            if (label.isEscape()) {
                writer.writeText((Object)value, "value");
            } else {
                writer.write(value);
            }
        }
        this.renderChildren(context, (UIComponent)label);
        if (input != null && label.isIndicateRequired()) {
            ConfigContainer config = RequestContext.getCurrentInstance().getApplicationContext().getConfig();
            if (input.isRequired()) {
                this.encodeRequiredIndicator(writer, label);
            } else if (config.isTransformMetadataEnabled()) {
                if (AbstractInputMetadataTransformer.isMarkedAsRequired(input)) {
                    this.encodeRequiredIndicator(writer, label);
                }
            } else if (config.isBeanValidationAvailable() && this.isNotNullDefined(input, context)) {
                this.encodeRequiredIndicator(writer, label);
            }
        }
        writer.endElement("label");
    }

    protected void encodeRequiredIndicator(ResponseWriter writer, OutputLabel label) throws IOException {
        writer.startElement("span", (UIComponent)label);
        writer.writeAttribute("class", (Object)"ui-outputlabel-rfi", null);
        writer.write("*");
        writer.endElement("span");
    }

    protected boolean isNotNullDefined(UIInput input, FacesContext context) {
        try {
            Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractDefaultConstraintDescriptors(context, RequestContext.getCurrentInstance(), input.getValueExpression("value"));
            if (constraints != null && !constraints.isEmpty()) {
                for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                    if (!constraintDescriptor.getAnnotation().annotationType().equals(NotNull.class)) continue;
                    return true;
                }
            }
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip evaluating @NotNull for outputPanel and referenced component \"" + input.getClientId(context) + "\" because" + " the ValueExpression of the \"value\" attribute" + " isn't resolvable completely (e.g. a sub-expression returns null)";
            LOG.log(Level.FINE, message);
        }
        return false;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

