/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectbooleancheckbox;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.selectbooleancheckbox.SelectBooleanCheckbox;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SelectBooleanCheckboxRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        SelectBooleanCheckbox checkbox = (SelectBooleanCheckbox)component;
        if (checkbox.isDisabled()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)checkbox);
        String clientId = checkbox.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        if (submittedValue != null && this.isChecked(submittedValue)) {
            checkbox.setSubmittedValue(true);
        } else {
            checkbox.setSubmittedValue(false);
        }
    }

    protected boolean isChecked(String value) {
        return value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectBooleanCheckbox checkbox = (SelectBooleanCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, SelectBooleanCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        boolean checked = Boolean.valueOf(ComponentUtils.getValueToRender(context, (UIComponent)checkbox));
        boolean disabled = checkbox.isDisabled();
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-chkbox ui-widget" : "ui-chkbox ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, checkbox, clientId, checked, disabled);
        this.encodeOutput(context, checkbox, checked, disabled);
        this.encodeItemLabel(context, checkbox, clientId);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, SelectBooleanCheckbox checkbox, String clientId, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
            writer.writeAttribute("aria-checked", (Object)"true", null);
        } else {
            writer.writeAttribute("aria-checked", (Object)"false", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checkbox.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)checkbox.getTabindex(), null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)checkbox);
        }
        this.renderOnchange(context, (UIComponent)checkbox);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOutput(FacesContext context, SelectBooleanCheckbox checkbox, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        styleClass = checked ? styleClass + " ui-state-active" : styleClass;
        styleClass = !checkbox.isValid() ? styleClass + " ui-state-error" : styleClass;
        styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
        String iconClass = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeItemLabel(FacesContext context, SelectBooleanCheckbox checkbox, String clientId) throws IOException {
        String label = checkbox.getItemLabel();
        if (label != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-chkbox-label", null);
            writer.writeText((Object)label, "itemLabel");
            writer.endElement("span");
        }
    }

    protected void encodeScript(FacesContext context, SelectBooleanCheckbox checkbox) throws IOException {
        String clientId = checkbox.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectBooleanCheckbox", checkbox.resolveWidgetVar(), clientId).finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue instanceof Boolean ? submittedValue : Boolean.valueOf(submittedValue.toString());
    }

    public String getHighlighter() {
        return "booleanchkbox";
    }
}

