/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.convert;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.convert.ConverterException;
import org.primefaces.component.calendar.CalendarUtils;
import org.primefaces.convert.ClientConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter
implements ClientConverter {
    private Map<String, Object> metadata;

    @Override
    public Map<String, Object> getMetadata() {
        if (this.metadata == null) {
            String pattern = this.getPattern();
            String type = this.getType();
            String dateStyle = this.getDateStyle();
            String timeStyle = this.getTimeStyle();
            this.metadata = new HashMap<String, Object>();
            if (pattern != null) {
                this.metadata.put("data-p-pattern", CalendarUtils.convertPattern(pattern));
            }
            if (type != null) {
                this.metadata.put("data-p-dttype", type);
                if (pattern == null) {
                    DateFormat df = null;
                    if (type.equals("both")) {
                        df = DateFormat.getDateInstance(this.getStyle(dateStyle), this.getLocale());
                        this.metadata.put("data-p-dspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                        df = DateFormat.getTimeInstance(this.getStyle(timeStyle), this.getLocale());
                        this.metadata.put("data-p-tspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    } else if (type.equals("date")) {
                        df = DateFormat.getDateInstance(this.getStyle(dateStyle), this.getLocale());
                        this.metadata.put("data-p-dspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    } else if (type.equals("time")) {
                        df = DateFormat.getTimeInstance(this.getStyle(timeStyle), this.getLocale());
                        this.metadata.put("data-p-tspattern", CalendarUtils.convertPattern(((SimpleDateFormat)df).toPattern()));
                    }
                }
            }
        }
        return this.metadata;
    }

    @Override
    public String getConverterId() {
        return "javax.faces.DateTime";
    }

    private int getStyle(String style) {
        if ("default".equals(style)) {
            return 2;
        }
        if ("short".equals(style)) {
            return 3;
        }
        if ("medium".equals(style)) {
            return 2;
        }
        if ("long".equals(style)) {
            return 1;
        }
        if ("full".equals(style)) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + style + '\'');
    }
}

