/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeChildren;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeNode
implements TreeNode,
Serializable {
    public static final String DEFAULT_TYPE = "default";
    private String type;
    private Object data;
    private List<TreeNode> children;
    private TreeNode parent;
    private boolean expanded;
    private boolean selected;
    private boolean selectable = true;
    private String rowKey;

    public DefaultTreeNode() {
        this.type = DEFAULT_TYPE;
        this.children = new TreeNodeChildren(this);
    }

    public DefaultTreeNode(Object data) {
        this.type = DEFAULT_TYPE;
        this.children = new TreeNodeChildren(this);
        this.data = data;
    }

    public DefaultTreeNode(Object data, TreeNode parent) {
        this.type = DEFAULT_TYPE;
        this.data = data;
        this.children = new TreeNodeChildren(this);
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    public DefaultTreeNode(String type, Object data, TreeNode parent) {
        this.type = type;
        this.data = data;
        this.children = new TreeNodeChildren(this);
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode> children) {
        if (children instanceof TreeNodeChildren) {
            this.children = children;
        } else {
            TreeNodeChildren nodeChildren = new TreeNodeChildren(this);
            nodeChildren.addAll((Collection<? extends TreeNode>)children);
            this.children = nodeChildren;
        }
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public void clearParent() {
        this.parent = null;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean value) {
        this.selected = value;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isLeaf() {
        if (this.children == null) {
            return true;
        }
        return this.children.isEmpty();
    }

    @Override
    public String getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTreeNode other = (DefaultTreeNode)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    @Override
    public boolean isPartialSelected() {
        return false;
    }

    @Override
    public void setPartialSelected(boolean value) {
    }
}

