/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.row.Row;
import org.primefaces.context.RequestContext;
import org.primefaces.event.data.PostFilterEvent;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.EqualsFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.model.filter.GreaterThanEqualsFilterConstraint;
import org.primefaces.model.filter.GreaterThanFilterConstraint;
import org.primefaces.model.filter.InFilterConstraint;
import org.primefaces.model.filter.LessThanEqualsFilterConstraint;
import org.primefaces.model.filter.LessThanFilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFeature
implements DataTableFeature {
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    private static final String STARTS_WITH_MATCH_MODE = "startsWith";
    private static final String ENDS_WITH_MATCH_MODE = "endsWith";
    private static final String CONTAINS_MATCH_MODE = "contains";
    private static final String EXACT_MATCH_MODE = "exact";
    private static final String LESS_THAN_MODE = "lt";
    private static final String LESS_THAN_EQUALS_MODE = "lte";
    private static final String GREATER_THAN_MODE = "gt";
    private static final String GREATER_THAN_EQUALS_MODE = "gte";
    private static final String EQUALS_MODE = "equals";
    private static final String IN_MODE = "in";
    private static final String GLOBAL_MODE = "global";
    static final Map<String, FilterConstraint> FILTER_CONSTRAINTS = new HashMap<String, FilterConstraint>();

    private boolean isFilterRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
        List<FilterMeta> filterMetadata = this.populateFilterMetaData(context, table);
        Map<String, Object> filterParameterMap = this.populateFilterParameterMap(context, table, filterMetadata, globalFilterParam);
        table.setFilters(filterParameterMap);
        table.setFilterMetadata(filterMetadata);
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        table.updateFilteredValue(context, null);
        table.setValue(null);
        table.setFirst(0);
        table.setRowIndex(-1);
        if (table.isLazy()) {
            table.loadLazyData();
        } else {
            boolean sorted;
            String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
            this.filter(context, table, table.getFilterMetadata(), globalFilterParam);
            boolean bl = sorted = table.getValueExpression("sortBy") != null || table.getSortBy() != null;
            if (sorted) {
                SortFeature sortFeature = (SortFeature)table.getFeature(DataTableFeatureKey.SORT);
                if (table.isMultiSort()) {
                    sortFeature.multiSort(context, table);
                } else {
                    sortFeature.singleSort(context, table);
                }
            }
        }
        context.getApplication().publishEvent(context, PostFilterEvent.class, (Object)table);
        renderer.encodeTbody(context, table, true);
    }

    public void filter(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, String globalFilterParam) {
        RequestContext requestContext;
        Map params = context.getExternalContext().getRequestParameterMap();
        ArrayList<Object> filteredData = new ArrayList<Object>();
        Locale filterLocale = table.resolveDataLocale();
        boolean hasGlobalFilter = globalFilterParam != null ? params.containsKey(globalFilterParam) : false;
        String globalFilterValue = hasGlobalFilter ? (String)params.get(globalFilterParam) : null;
        GlobalFilterConstraint globalFilterConstraint = (GlobalFilterConstraint)FILTER_CONSTRAINTS.get(GLOBAL_MODE);
        ELContext elContext = context.getELContext();
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            boolean localMatch = true;
            boolean globalMatch = false;
            for (FilterMeta filterMeta : filterMetadata) {
                Object filterValue = filterMeta.getFilterValue();
                UIColumn column = filterMeta.getColumn();
                MethodExpression filterFunction = column.getFilterFunction();
                ValueExpression filterByVE = filterMeta.getFilterByVE();
                if (column instanceof DynamicColumn) {
                    ((DynamicColumn)column).applyStatelessModel();
                }
                Object columnValue = filterByVE.getValue(elContext);
                FilterConstraint filterConstraint = this.getFilterConstraint(column);
                if (hasGlobalFilter && !globalMatch) {
                    globalMatch = globalFilterConstraint.applies(columnValue, globalFilterValue, filterLocale);
                }
                if (filterFunction != null) {
                    localMatch = (Boolean)filterFunction.invoke(elContext, new Object[]{columnValue, filterValue, filterLocale});
                } else if (!filterConstraint.applies(columnValue, filterValue, filterLocale)) {
                    localMatch = false;
                }
                if (localMatch) continue;
                break;
            }
            boolean matches = localMatch;
            if (hasGlobalFilter) {
                boolean bl = matches = localMatch && globalMatch;
            }
            if (!matches) continue;
            filteredData.add(table.getRowData());
        }
        if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
            requestContext.addCallbackParam("totalRecords", filteredData.size());
        }
        table.updateFilteredValue(context, filteredData);
        table.updateValue(table.getFilteredValue());
        table.setRowIndex(-1);
    }

    private Map<String, Object> populateFilterParameterMap(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, String globalFilterParam) {
        Map params = context.getExternalContext().getRequestParameterMap();
        HashMap<String, Object> filterParameterMap = new HashMap<String, Object>();
        for (FilterMeta filterMeta : filterMetadata) {
            Object filterValue = filterMeta.getFilterValue();
            UIColumn column = filterMeta.getColumn();
            if (filterValue == null || filterValue.toString().trim().equals("")) continue;
            String filterField = null;
            ValueExpression filterByVE = column.getValueExpression("filterBy");
            if (column.isDynamic()) {
                ((DynamicColumn)column).applyStatelessModel();
                Object filterByProperty = column.getFilterBy();
                String field = column.getField();
                filterField = field == null ? (filterByProperty == null ? table.resolveDynamicField(filterByVE) : filterByProperty.toString()) : field;
            } else {
                String field = column.getField();
                filterField = field == null ? (filterByVE == null ? (String)column.getFilterBy() : table.resolveStaticField(filterByVE)) : field;
            }
            filterParameterMap.put(filterField, filterValue);
        }
        if (params.containsKey(globalFilterParam)) {
            filterParameterMap.put("globalFilter", params.get(globalFilterParam));
        }
        return filterParameterMap;
    }

    public List<FilterMeta> populateFilterMetaData(FacesContext context, DataTable table) {
        boolean hasFrozenColumns;
        ArrayList<FilterMeta> filterMetadata = new ArrayList<FilterMeta>();
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        Map params = context.getExternalContext().getRequestParameterMap();
        boolean bl = hasFrozenColumns = table.getFrozenColumns() > 0;
        if (!hasFrozenColumns) {
            ColumnGroup headerGroup = this.getColumnGroup(table, "header");
            if (headerGroup != null) {
                this.populateFilterMetaDataInColumnGroup(context, filterMetadata, headerGroup, params, separator);
            } else {
                this.populateFilterMetaDataWithoutColumnGroups(context, table, filterMetadata, params, separator);
            }
        } else {
            ColumnGroup frozenHeaderGroup = this.getColumnGroup(table, "frozenHeader");
            ColumnGroup scrollableHeaderGroup = this.getColumnGroup(table, "scrollableHeader");
            if (frozenHeaderGroup != null) {
                this.populateFilterMetaDataInColumnGroup(context, filterMetadata, frozenHeaderGroup, params, separator);
                this.populateFilterMetaDataInColumnGroup(context, filterMetadata, scrollableHeaderGroup, params, separator);
            } else {
                this.populateFilterMetaDataWithoutColumnGroups(context, table, filterMetadata, params, separator);
            }
        }
        return filterMetadata;
    }

    private void populateFilterMetaDataInColumnGroup(FacesContext context, List<FilterMeta> filterMetadata, ColumnGroup group, Map<String, String> params, String separator) {
        if (group == null) {
            return;
        }
        for (UIComponent child : group.getChildren()) {
            Row headerRow = (Row)child;
            if (!headerRow.isRendered()) continue;
            for (UIComponent headerRowChild : headerRow.getChildren()) {
                if (headerRowChild instanceof Column) {
                    ValueExpression columnFilterByVE;
                    Column column = (Column)headerRowChild;
                    if (!column.isRendered() || (columnFilterByVE = column.getValueExpression("filterBy")) == null) continue;
                    ValueExpression filterByVE = columnFilterByVE;
                    UIComponent filterFacet = column.getFacet("filter");
                    Object filterValue = filterFacet == null ? params.get(column.getClientId(context) + separator + "filter") : ((ValueHolder)filterFacet).getLocalValue();
                    filterMetadata.add(new FilterMeta(column, filterByVE, filterValue));
                    continue;
                }
                if (!(headerRowChild instanceof Columns)) continue;
                Columns uiColumns = (Columns)headerRowChild;
                List<DynamicColumn> dynamicColumns = uiColumns.getDynamicColumns();
                for (DynamicColumn dynaColumn : dynamicColumns) {
                    ValueExpression columnFilterByVE;
                    dynaColumn.applyStatelessModel();
                    if (!dynaColumn.isRendered() || (columnFilterByVE = dynaColumn.getValueExpression("filterBy")) == null) continue;
                    String filterId = dynaColumn.getContainerClientId(context) + separator + "filter";
                    UIComponent filterFacet = dynaColumn.getFacet("filter");
                    Object filterValue = filterFacet == null ? params.get(filterId) : ((ValueHolder)filterFacet).getLocalValue();
                    filterMetadata.add(new FilterMeta(dynaColumn, columnFilterByVE, filterValue));
                }
            }
        }
    }

    private void populateFilterMetaDataWithoutColumnGroups(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, Map<String, String> params, String separator) {
        for (UIColumn column : table.getColumns()) {
            ValueExpression columnFilterByVE = column.getValueExpression("filterBy");
            if (columnFilterByVE == null) continue;
            UIComponent filterFacet = column.getFacet("filter");
            ValueExpression filterByVE = columnFilterByVE;
            Object filterValue = null;
            String filterId = null;
            if (column instanceof Column) {
                filterId = column.getClientId(context) + separator + "filter";
            } else if (column instanceof DynamicColumn) {
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyStatelessModel();
                filterId = dynamicColumn.getContainerClientId(context) + separator + "filter";
                dynamicColumn.cleanStatelessModel();
            }
            filterValue = filterFacet == null ? params.get(filterId) : ((ValueHolder)filterFacet).getLocalValue();
            filterMetadata.add(new FilterMeta(column, filterByVE, filterValue));
        }
    }

    private ColumnGroup getColumnGroup(DataTable table, String target) {
        for (UIComponent child : table.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public FilterConstraint getFilterConstraint(UIColumn column) {
        String filterMatchMode = column.getFilterMatchMode();
        FilterConstraint filterConstraint = FILTER_CONSTRAINTS.get(filterMatchMode);
        if (filterConstraint == null) {
            throw new FacesException("Illegal filter match mode:" + filterMatchMode);
        }
        return filterConstraint;
    }

    static {
        FILTER_CONSTRAINTS.put(STARTS_WITH_MATCH_MODE, new StartsWithFilterConstraint());
        FILTER_CONSTRAINTS.put(ENDS_WITH_MATCH_MODE, new EndsWithFilterConstraint());
        FILTER_CONSTRAINTS.put(CONTAINS_MATCH_MODE, new ContainsFilterConstraint());
        FILTER_CONSTRAINTS.put(EXACT_MATCH_MODE, new ExactFilterConstraint());
        FILTER_CONSTRAINTS.put(LESS_THAN_MODE, new LessThanFilterConstraint());
        FILTER_CONSTRAINTS.put(LESS_THAN_EQUALS_MODE, new LessThanEqualsFilterConstraint());
        FILTER_CONSTRAINTS.put(GREATER_THAN_MODE, new GreaterThanFilterConstraint());
        FILTER_CONSTRAINTS.put(GREATER_THAN_EQUALS_MODE, new GreaterThanEqualsFilterConstraint());
        FILTER_CONSTRAINTS.put(EQUALS_MODE, new EqualsFilterConstraint());
        FILTER_CONSTRAINTS.put(IN_MODE, new InFilterConstraint());
        FILTER_CONSTRAINTS.put(GLOBAL_MODE, new GlobalFilterConstraint());
    }
}

