/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spotlight;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.spotlight.Spotlight;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SpotlightRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Spotlight spotlight = (Spotlight)component;
        this.encodeMarkup(context, spotlight);
        this.encodeScript(context, spotlight);
    }

    private void encodeMarkup(FacesContext context, Spotlight spotlight) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)spotlight);
        writer.writeAttribute("id", (Object)spotlight.getClientId(context), null);
        writer.endElement("span");
    }

    private void encodeScript(FacesContext context, Spotlight spotlight) throws IOException {
        String clientId = spotlight.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Spotlight", spotlight.resolveWidgetVar(), clientId);
        wb.attr("target", SearchExpressionFacade.resolveClientIds(context, (UIComponent)spotlight, spotlight.getTarget()));
        wb.attr("animate", spotlight.isAnimate(), true);
        wb.finish();
    }
}

