/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.validation.Validation;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.primefaces.util.ComponentUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigContainer {
    private static final Logger LOG = Logger.getLogger(ConfigContainer.class.getName());
    private boolean validateEmptyFields = false;
    private boolean partialSubmitEnabled = false;
    private boolean resetValuesEnabled = false;
    private boolean interpretEmptyStringAsNull = false;
    private String secretKey = null;
    private String pushServerURL = null;
    private String theme = null;
    private String mobileTheme = null;
    private boolean fontAwesomeEnabled = false;
    private boolean clientSideValidationEnabled = false;
    private String uploader = null;
    private boolean transformMetadataEnabled = false;
    private boolean legacyWidgetNamespace = false;
    private boolean beanValidationDisabled = false;
    private boolean beanValidationAvailable = false;
    private boolean stringConverterAvailable = false;
    private boolean el22Available = false;
    private boolean jsf22 = false;
    private boolean jsf21 = false;
    private String buildVersion = null;
    private Map<String, String> errorPages;

    protected ConfigContainer() {
    }

    public ConfigContainer(FacesContext context) {
        this.initConfigFromContextParams(context);
        this.initConfig(context);
        this.initBuildProperties();
        this.initConfigFromWebXml(context);
        this.initValidateEmptyFields(context);
    }

    protected void initConfig(FacesContext context) {
        this.el22Available = this.checkIfEL22IsAvailable();
        this.beanValidationAvailable = this.checkIfBeanValidationIsAvailable();
        this.jsf22 = this.detectJSF22();
        this.jsf21 = this.jsf22 ? true : this.detectJSF21();
        this.stringConverterAvailable = null != context.getApplication().createConverter(String.class);
    }

    protected void initConfigFromContextParams(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String value = null;
        value = externalContext.getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
        this.interpretEmptyStringAsNull = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.SUBMIT");
        this.partialSubmitEnabled = value == null ? false : value.equalsIgnoreCase("partial");
        value = externalContext.getInitParameter("primefaces.RESET_VALUES");
        this.resetValuesEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.SECRET");
        this.secretKey = value == null ? "primefaces" : value;
        value = externalContext.getInitParameter("primefaces.CLIENT_SIDE_VALIDATION");
        this.clientSideValidationEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.UPLOADER");
        this.uploader = value == null ? "auto" : value;
        this.pushServerURL = externalContext.getInitParameter("primefaces.PUSH_SERVER_URL");
        this.theme = externalContext.getInitParameter("primefaces.THEME");
        this.mobileTheme = externalContext.getInitParameter("primefaces.mobile.THEME");
        value = externalContext.getInitParameter("primefaces.FONT_AWESOME");
        this.fontAwesomeEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.TRANSFORM_METADATA");
        this.transformMetadataEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.LEGACY_WIDGET_NAMESPACE");
        this.legacyWidgetNamespace = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("javax.faces.validator.DISABLE _DEFAULT_BEAN_VALIDATOR");
        this.beanValidationDisabled = value == null ? false : Boolean.valueOf(value);
    }

    protected void initValidateEmptyFields(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String param = externalContext.getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
        if (param == null && externalContext.getApplicationMap().containsKey("javax.faces.VALIDATE_EMPTY_FIELDS")) {
            Object applicationMapValue = externalContext.getApplicationMap().get("javax.faces.VALIDATE_EMPTY_FIELDS");
            if (applicationMapValue instanceof String) {
                param = (String)applicationMapValue;
            } else if (applicationMapValue instanceof Boolean) {
                this.validateEmptyFields = (Boolean)applicationMapValue;
                return;
            }
        }
        param = param == null ? "auto" : param.toLowerCase();
        this.validateEmptyFields = param.equals("auto") && this.beanValidationAvailable || param.equals("true");
    }

    protected void initBuildProperties() {
        Properties buildProperties = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/META-INF/maven/org.primefaces/primefaces/pom.properties");
            buildProperties.load(is);
            this.buildVersion = buildProperties.getProperty("version");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not load pom.properties", e);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkIfBeanValidationIsAvailable() {
        boolean available = false;
        try {
            available = Class.forName("javax.validation.Validation") != null;
        }
        catch (ClassNotFoundException e) {
            available = false;
        }
        if (available) {
            try {
                Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "BV not available - Could not build default ValidatorFactory.");
                available = false;
            }
        }
        return available && !this.beanValidationDisabled && this.el22Available;
    }

    private boolean checkIfEL22IsAvailable() {
        boolean available;
        try {
            available = Class.forName("javax.el.ValueReference") != null;
        }
        catch (ClassNotFoundException e) {
            available = false;
        }
        return available;
    }

    private boolean detectJSF22() {
        String version = FacesContext.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version.startsWith("2.2");
        }
        try {
            Class.forName("javax.faces.flow.Flow");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private boolean detectJSF21() {
        String version = FacesContext.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version.startsWith("2.1");
        }
        try {
            ViewHandler.class.getDeclaredMethod("deriveLogicalViewId", FacesContext.class, String.class);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConfigFromWebXml(FacesContext context) {
        InputStream is = null;
        try {
            is = context.getExternalContext().getResourceAsStream("/WEB-INF/web.xml");
            if (is != null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(false);
                factory.setExpandEntityReferences(false);
                factory.setFeature("http://xml.org/sax/features/namespaces", false);
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(is);
                this.initErrorPages(document.getDocumentElement());
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not load or parse web.xml", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "Could not close web.xml stream", e);
                }
            }
        }
    }

    private void initErrorPages(Element webXml) throws Exception {
        this.errorPages = new HashMap<String, String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList exceptionTypes = (NodeList)xpath.compile("error-page/exception-type").evaluate(webXml, XPathConstants.NODESET);
        for (int i = 0; i < exceptionTypes.getLength(); ++i) {
            Node node = exceptionTypes.item(i);
            String exceptionType = node.getTextContent().trim();
            String key = Throwable.class.getName().equals(exceptionType) ? null : exceptionType;
            String location = xpath.compile("location").evaluate(node.getParentNode()).trim();
            if (this.errorPages.containsKey(key)) continue;
            this.errorPages.put(key, location);
        }
        if (!this.errorPages.containsKey(null)) {
            String defaultLocation = xpath.compile("error-page[error-code=500]/location").evaluate(webXml).trim();
            if (ComponentUtils.isValueBlank(defaultLocation)) {
                defaultLocation = xpath.compile("error-page[not(error-code) and not(exception-type)]/location").evaluate(webXml).trim();
            }
            if (!ComponentUtils.isValueBlank(defaultLocation)) {
                this.errorPages.put(null, defaultLocation);
            }
        }
    }

    public boolean isValidateEmptyFields() {
        return this.validateEmptyFields;
    }

    public boolean isBeanValidationAvailable() {
        return this.beanValidationAvailable;
    }

    public boolean isEL22Available() {
        return this.el22Available;
    }

    public boolean isPartialSubmitEnabled() {
        return this.partialSubmitEnabled;
    }

    public boolean isInterpretEmptyStringAsNull() {
        return this.interpretEmptyStringAsNull;
    }

    public boolean isStringConverterAvailable() {
        return this.stringConverterAvailable;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isAtLeastJSF22() {
        return this.jsf22;
    }

    public boolean isAtLeastJSF21() {
        return this.jsf21;
    }

    public boolean isResetValuesEnabled() {
        return this.resetValuesEnabled;
    }

    public boolean isClientSideValidationEnabled() {
        return this.clientSideValidationEnabled;
    }

    public String getUploader() {
        return this.uploader;
    }

    public String getPushServerURL() {
        return this.pushServerURL;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getMobileTheme() {
        return this.mobileTheme;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public Map<String, String> getErrorPages() {
        return this.errorPages;
    }

    public boolean isTransformMetadataEnabled() {
        return this.transformMetadataEnabled;
    }

    public boolean isLegacyWidgetNamespace() {
        return this.legacyWidgetNamespace;
    }

    public boolean isFontAwesomeEnabled() {
        return this.fontAwesomeEnabled;
    }
}

