/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datagrid.DataGrid;
import org.primefaces.mobile.renderkit.paginator.PaginatorRenderer;
import org.primefaces.mobile.util.MobileUtils;
import org.primefaces.util.WidgetBuilder;

public class DataGridRenderer
extends org.primefaces.component.datagrid.DataGridRenderer {
    protected void encodeScript(FacesContext context, DataGrid grid) throws IOException {
        String clientId = grid.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataGrid", grid.resolveWidgetVar(), clientId);
        if (grid.isPaginator()) {
            PaginatorRenderer paginatorRenderer = this.getPaginatorRenderer(context);
            paginatorRenderer.encodeScript(context, grid, wb);
        }
        this.encodeClientBehaviors(context, grid);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataGrid grid) throws IOException {
        String contentClass;
        if (grid.isLazy()) {
            grid.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId(context);
        boolean hasPaginator = grid.isPaginator();
        boolean empty = grid.getRowCount() == 0;
        String paginatorPosition = grid.getPaginatorPosition();
        String style = grid.getStyle();
        String styleClass = grid.getStyleClass() == null ? "ui-datagrid" : "ui-datagrid " + grid.getStyleClass();
        PaginatorRenderer paginatorRenderer = this.getPaginatorRenderer(context);
        if (empty) {
            contentClass = "ui-datagrid-content ui-datagrid-content-empty";
        } else {
            contentClass = "ui-datagrid-content ui-responsive";
            int columns = grid.getColumns();
            if (columns == 0) {
                columns = 1;
            }
            String gridClass = MobileUtils.GRID_MAP.get(columns);
            contentClass = contentClass + " " + gridClass;
        }
        if (hasPaginator) {
            grid.calculateFirst();
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, grid, "header", "ui-datagrid-header ui-bar ui-bar-b");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            paginatorRenderer.encodeMarkup(context, grid, "top");
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (empty) {
            writer.write(grid.getEmptyMessage());
        } else {
            this.encodeContent(context, grid);
        }
        writer.endElement("div");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            paginatorRenderer.encodeMarkup(context, grid, "bottom");
        }
        this.encodeFacet(context, grid, "footer", "ui-datagrid-footer ui-bar ui-bar-b");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int first = grid.getFirst();
        int rows = grid.getRows();
        int last = rows != 0 ? first + rows : grid.getRowCount();
        for (int i = first; i < last; ++i) {
            grid.setRowIndex(i);
            if (!grid.isRowAvailable()) break;
            for (UIComponent child : grid.getChildren()) {
                if (!child.isRendered()) continue;
                int blockKey = i % columns;
                String blockClass = MobileUtils.BLOCK_MAP.get(blockKey);
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)blockClass, null);
                child.encodeAll(context);
                writer.endElement("div");
            }
        }
        grid.setRowIndex(-1);
    }

    private PaginatorRenderer getPaginatorRenderer(FacesContext context) {
        return (PaginatorRenderer)context.getRenderKit().getRenderer("org.primefaces.component", "org.primefaces.component.PaginatorRenderer");
    }
}

