/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputswitch.InputSwitch;
import org.primefaces.mobile.component.uiswitch.UISwitch;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class InputSwitchRenderer
extends org.primefaces.component.inputswitch.InputSwitchRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputSwitch inputSwitch = (InputSwitch)component;
        this.encodeMarkup(context, inputSwitch);
        this.encodeScript(context, inputSwitch);
    }

    public void encodeMarkup(FacesContext context, InputSwitch inputSwitch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputSwitch.getClientId(context);
        boolean checked = Boolean.valueOf(ComponentUtils.getValueToRender(context, (UIComponent)inputSwitch));
        String inputId = clientId + "_input";
        String onLabel = inputSwitch.getOnLabel();
        String offLabel = inputSwitch.getOffLabel();
        String style = inputSwitch.getStyle();
        String styleClass = inputSwitch.getStyleClass();
        styleClass = styleClass == null ? UISwitch.CONTAINER_CLASS : UISwitch.CONTAINER_CLASS + " " + styleClass;
        writer.startElement("div", (UIComponent)inputSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.startElement("span", (UIComponent)inputSwitch);
        writer.writeAttribute("class", (Object)UISwitch.ON_CLASS, null);
        writer.writeText((Object)onLabel, null);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)inputSwitch);
        writer.writeAttribute("class", (Object)UISwitch.OFF_CLASS, null);
        writer.writeText((Object)offLabel, null);
        writer.endElement("span");
        writer.startElement("input", (UIComponent)inputSwitch);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("data-role", (Object)"none", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)UISwitch.INPUT_CLASS, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (inputSwitch.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.renderOnchange(context, (UIComponent)inputSwitch);
        writer.endElement("input");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, InputSwitch inputSwitch) throws IOException {
        String clientId = inputSwitch.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("UISwitch", inputSwitch.resolveWidgetVar(), clientId).finish();
    }
}

