/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.servlet.ServletInputStream;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.primefaces.push.PushRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeAtmosphereHandler
extends AbstractReflectorAtmosphereHandler {
    private final Logger logger = LoggerFactory.getLogger(PrimeAtmosphereHandler.class);
    private final List<PushRule> rules;

    public PrimeAtmosphereHandler(List<PushRule> rules) {
        this.rules = rules;
    }

    public void onRequest(AtmosphereResource resource) throws IOException {
        AtmosphereRequest r = resource.getRequest();
        if (r.getMethod().equalsIgnoreCase("GET")) {
            this.applyRules(resource);
        } else {
            StringBuilder stringBuilder = this.read(resource);
            resource.getAtmosphereConfig().metaBroadcaster().broadcastTo("/*", (Object)stringBuilder.toString());
        }
    }

    protected void applyRules(AtmosphereResource resource) {
        for (PushRule r : this.rules) {
            boolean ok = r.apply(resource);
            if (ok) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder read(AtmosphereResource r) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            block18: {
                try {
                    ServletInputStream inputStream = r.getRequest().getInputStream();
                    if (inputStream != null) {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                    }
                }
                catch (IllegalStateException ex) {
                    this.logger.trace("", (Throwable)ex);
                    BufferedReader reader = r.getRequest().getReader();
                    if (reader == null) break block18;
                    bufferedReader = new BufferedReader(reader);
                }
            }
            if (bufferedReader != null) {
                char[] charBuffer = new char[8192];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            this.logger.warn("", (Throwable)ex);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    this.logger.warn("", (Throwable)ex);
                }
            }
        }
        return stringBuilder;
    }
}

