/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.primefaces.push.EventBusFactory;
import org.primefaces.push.PushContext;
import org.primefaces.push.PushContextFactory;
import org.primefaces.push.PushContextImpl;
import org.primefaces.push.impl.PushEndpointProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushServlet
extends AtmosphereServlet {
    private final Logger logger = LoggerFactory.getLogger((String)PushServlet.class.getName());

    public PushServlet() {
        this(false);
    }

    public PushServlet(boolean isFilter) {
        super(isFilter, true);
    }

    public PushServlet(boolean isFilter, boolean autoDetectHandlers) {
        super(isFilter, autoDetectHandlers);
    }

    protected PushServlet configureFramework(ServletConfig sc) throws ServletException {
        boolean notConfigured;
        super.configureFramework(sc, false);
        this.framework().interceptor((AtmosphereInterceptor)new AtmosphereResourceLifecycleInterceptor()).interceptor((AtmosphereInterceptor)new TrackMessageSizeInterceptor()).addAnnotationPackage(PushEndpointProcessor.class);
        this.framework().getAtmosphereConfig().startupHook(new AtmosphereConfig.StartupHook(){

            public void started(AtmosphereFramework framework) {
                PushServlet.this.configureMetaBroadcasterCache(framework);
            }
        });
        boolean bl = notConfigured = sc.getInitParameter("org.atmosphere.util.IOUtils.readGetBody") == null;
        if (notConfigured) {
            this.framework().addInitParameter("org.atmosphere.util.IOUtils.readGetBody", "true");
        }
        this.framework().init(sc);
        PushContextFactory pcf = new PushContextFactory(this.framework().getAtmosphereConfig().metaBroadcaster());
        PushContext c = pcf.getPushContext();
        if (PushContextImpl.class.isAssignableFrom(c.getClass())) {
            this.framework().asyncSupportListener((AsyncSupportListener)PushContextImpl.class.cast(c));
        }
        EventBusFactory f = new EventBusFactory(this.framework().getAtmosphereConfig().metaBroadcaster());
        this.framework().getAtmosphereConfig().properties().put("evenBus", f.eventBus());
        if (this.framework().getAtmosphereHandlers().size() == 0) {
            this.logger.error("No Annotated class using @PushEndpoint found. Push will not work.");
        }
        return this;
    }

    protected void configureMetaBroadcasterCache(AtmosphereFramework framework) {
        MetaBroadcaster m = framework.metaBroadcaster();
        m.cache((MetaBroadcaster.MetaBroadcasterCache)new MetaBroadcaster.ThirtySecondsCache(m, framework.getAtmosphereConfig()));
    }
}

