(function($) {
    $(function() {
        var jcarousel = $('.jcarousel');

        jcarousel
            .on('jcarousel:reload jcarousel:create', function () {
                var width = jcarousel.innerWidth();

                if (width >= 600) {
                    width = width / 3;
                } else if (width >= 350) {
                    width = width / 2;
                }

                jcarousel.jcarousel('items').css('width', width + 'px');
                jcarousel.jcarousel('items').css('overflow', 'hidden');
            })
            .jcarousel({
                wrap: 'circular'
            });

        $('.jcarousel-control-prev')
            .jcarouselControl({
                target: '-=1'
            });

        $('.jcarousel-control-next')
            .jcarouselControl({
                target: '+=1'
            });

        $('.jcarousel-pagination')
            .on('jcarouselpagination:active', 'a', function() {
                $(this).addClass('active');
            })
            .on('jcarouselpagination:inactive', 'a', function() {
                $(this).removeClass('active');
            })
            .on('click', function(e) {
                e.preventDefault();
            })
            .jcarouselPagination({
                perPage: 1,
                item: function(page) {
                    return '<a href="#' + page + '">' + page + '</a>';
                }
            });
    });

    $(function() {
        var jcarousel_details = $('.jcarousel-details');
        console.log('foi');
        jcarousel_details
            .on('jcarousel:reload jcarousel:create', function () {
                var width = jcarousel_details.innerWidth();

                if (width >= 600) {
                    width = width / 3;
                } else if (width >= 350) {
                    width = width / 2;
                }

                jcarousel_details.jcarousel('items').css('width', width + 'px');
                jcarousel_details.jcarousel('items').css('overflow', 'hidden');
            })
            .jcarousel({
                wrap: 'circular'
            });

        $('.jcarousel-control-prev-details')
            .jcarouselControl({
                target: '-=1'
            });

        $('.jcarousel-control-next-details')
            .jcarouselControl({
                target: '+=1'
            });

        $('.jcarousel-pagination-details')
            .on('jcarouselpagination-details:active', 'a', function() {
                $(this).addClass('active');
            })
            .on('jcarouselpagination-details:inactive', 'a', function() {
                $(this).removeClass('active');
            })
            .on('click', function(e) {
                e.preventDefault();
            })
            .jcarouselPagination({
                perPage: 1,
                item: function(page) {
                    return '<a href="#' + page + '">' + page + '</a>';
                }
            });
    });
})(jQuery);
